import csv
from pathlib import Path
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt

asset_dir = Path(__file__).resolve().parent
csv_path = asset_dir / 'top10-gdp-per-capita-ppp-2025.csv'

rows = []
with csv_path.open(newline='', encoding='utf-8') as f:
    reader = csv.DictReader(f)
    for r in reader:
        rows.append((int(r['Rank']), r['Economy'], float(r['GDP_per_capita_PPP_int$'])))

# Sort for plotting (descending value)
rows.sort(key=lambda x: x[2])
ranks, economies, values = zip(*rows)

fig = plt.figure(figsize=(12, 7), dpi=200)
ax = fig.add_subplot(111)

ax.barh(economies, values)
ax.set_xlabel('GDP per capita (PPP), international dollars (int$)', fontsize=15, color='black')
ax.set_ylabel('Economy', fontsize=15, color='black')
ax.set_title('Top 10 Countries by GDP per Capita (PPP), 2025 (est.)', fontsize=17, color='black')

# Tick styling (black, >=15px equivalent)
ax.tick_params(axis='both', which='major', labelsize=15, colors='black')

# Value labels
for y, v in enumerate(values):
    ax.text(v * 1.005, y, f"{v:,.2f}", va='center', fontsize=15, color='black')

# Margins and grid
ax.grid(axis='x', linestyle=':', linewidth=1, alpha=0.4)
fig.tight_layout()

png_path = asset_dir / 'chart-top10-gdp-per-capita-ppp-2025.png'
svg_path = asset_dir / 'chart-top10-gdp-per-capita-ppp-2025.svg'
fig.savefig(png_path, bbox_inches='tight')
fig.savefig(svg_path, bbox_inches='tight')
print('Saved:', png_path.name, 'and', svg_path.name)
